/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.lad.ruleManager;

import java.io.Serializable;
import java.util.ArrayList;
import weka.classifiers.rules.lad.core.NumericalRule;
import weka.core.Instance;
import weka.core.Instances;

public class RuleManager
implements Serializable {
    private static final long serialVersionUID = 1956931334238019791L;
    private ArrayList<NumericalRule> mPositiveRules = new ArrayList();
    private ArrayList<NumericalRule> mNegativeRules = new ArrayList();
    private Integer largerClass = null;
    private static final double IncDecValue = 0.01;
    private String mPSRepresentation;
    private ArrayList<NumericalRule> mActiveRules = new ArrayList();
    private String[] mAttNames;

    public void addRule(NumericalRule nRule) {
        if (nRule.isPositive() && !this.mPositiveRules.contains(nRule)) {
            this.mPositiveRules.add(nRule);
        } else if (nRule.isNegative() && !this.mNegativeRules.contains(nRule)) {
            this.mNegativeRules.add(nRule);
        }
    }

    public void adjustRulesWeight(Instances trainingSet) {
        double normalProportion = 1.0 / (double)this.mPositiveRules.size();
        for (NumericalRule r : this.mPositiveRules) {
            r.setWeight(normalProportion);
        }
        normalProportion = 1.0 / (double)this.mNegativeRules.size();
        for (NumericalRule r : this.mNegativeRules) {
            r.setWeight(normalProportion);
        }
        double[] dist = null;
        for (Instance inst : trainingSet) {
            dist = this.distributionForInstance(inst);
            if (inst.classValue() == 0.0 && dist[1] > dist[0]) {
                for (NumericalRule r : this.mActiveRules) {
                    if (r.isPositive()) {
                        r.increaseWeight(0.01);
                        continue;
                    }
                    r.decreaseWeight(0.01);
                }
                continue;
            }
            if (inst.classValue() != 1.0 || !(dist[0] > dist[1])) continue;
            for (NumericalRule r : this.mActiveRules) {
                if (r.isNegative()) {
                    r.increaseWeight(0.01);
                    continue;
                }
                r.decreaseWeight(0.01);
            }
        }
        normalProportion = 0.0;
        for (NumericalRule r : this.mPositiveRules) {
            normalProportion += r.getWeight();
        }
        for (NumericalRule r : this.mPositiveRules) {
            r.setWeight(r.getWeight() / normalProportion);
        }
        normalProportion = 0.0;
        for (NumericalRule r : this.mNegativeRules) {
            normalProportion += r.getWeight();
        }
        for (NumericalRule r : this.mNegativeRules) {
            r.setWeight(r.getWeight() / normalProportion);
        }
        this.largerClass = trainingSet.attributeStats((int)trainingSet.classIndex()).nominalCounts[0] > trainingSet.attributeStats((int)trainingSet.classIndex()).nominalCounts[1] ? Integer.valueOf(0) : Integer.valueOf(1);
    }

    public double[] distributionForInstance(Instance inst) {
        int P = 0;
        int N = 1;
        this.mActiveRules.clear();
        double[] distribution = new double[2];
        distribution[P] = 0.0;
        distribution[N] = 0.0;
        for (NumericalRule r : this.mPositiveRules) {
            if (!r.isCovering(inst)) continue;
            int n = P;
            distribution[n] = distribution[n] + r.getWeight();
            this.mActiveRules.add(r);
        }
        for (NumericalRule r : this.mNegativeRules) {
            if (!r.isCovering(inst)) continue;
            int n = N;
            distribution[n] = distribution[n] + r.getWeight();
            this.mActiveRules.add(r);
        }
        if (distribution[P] == distribution[N] && this.largerClass != null) {
            distribution[N] = 0.0;
            distribution[P] = 0.0;
            distribution[this.largerClass.intValue()] = 1.0;
        }
        return distribution;
    }

    public double[] distributionForInstancePSR(Instance inst) {
        int P = 0;
        int N = 1;
        this.mActiveRules.clear();
        double[] distribution = new double[2];
        distribution[P] = 0.0;
        distribution[N] = 0.0;
        this.mPSRepresentation = "";
        for (NumericalRule r : this.mPositiveRules) {
            if (r.isCovering(inst)) {
                int n = P;
                distribution[n] = distribution[n] + r.getWeight();
                this.mActiveRules.add(r);
                this.mPSRepresentation = String.valueOf(this.mPSRepresentation) + "1,";
                continue;
            }
            this.mPSRepresentation = String.valueOf(this.mPSRepresentation) + "0,";
        }
        this.mPSRepresentation = String.valueOf(this.mPSRepresentation);
        for (NumericalRule r : this.mNegativeRules) {
            if (r.isCovering(inst)) {
                int n = N;
                distribution[n] = distribution[n] + r.getWeight();
                this.mActiveRules.add(r);
                this.mPSRepresentation = String.valueOf(this.mPSRepresentation) + "1,";
                continue;
            }
            this.mPSRepresentation = String.valueOf(this.mPSRepresentation) + "0,";
        }
        if (distribution[P] == distribution[N] && this.largerClass != null) {
            distribution[N] = 0.0;
            distribution[P] = 0.0;
            distribution[this.largerClass.intValue()] = 1.0;
            this.mPSRepresentation = String.valueOf(this.mPSRepresentation) + " " + this.largerClass;
        } else if (distribution[P] != distribution[N]) {
            this.mPSRepresentation = String.valueOf(this.mPSRepresentation) + " " + (distribution[P] > distribution[N] ? P : N);
        }
        return distribution;
    }

    public void setAttNames(Instances data) {
        this.mAttNames = new String[data.numAttributes()];
        int i = 0;
        while (i < this.mAttNames.length) {
            this.mAttNames[i] = data.attribute(i).name();
            ++i;
        }
    }

    public ArrayList<NumericalRule> getPositiveRules() {
        return this.mPositiveRules;
    }

    public int numPositiveRules() {
        return this.mPositiveRules.size();
    }

    public ArrayList<NumericalRule> getNegativeRules() {
        return this.mNegativeRules;
    }

    public int numNegativeRules() {
        return this.mNegativeRules.size();
    }

    public String getLastRepresentation() {
        return this.mPSRepresentation;
    }

    public String toString() {
        String s = " @ Positive patterns:\n\n";
        for (NumericalRule r : this.mPositiveRules) {
            s = String.valueOf(s) + r.toString(this.mAttNames) + "\n";
        }
        s = String.valueOf(s) + "\n # Total: " + this.mPositiveRules.size() + " positive patterns\n";
        s = String.valueOf(s) + "\n @ Negative patterns:\n\n";
        for (NumericalRule r : this.mNegativeRules) {
            s = String.valueOf(s) + r.toString(this.mAttNames) + "\n";
        }
        s = String.valueOf(s) + "\n # Total: " + this.mNegativeRules.size() + " negative patterns";
        return s;
    }
}

